%% Decription: Determines y=f(x) by linear interpolation for a function f 
%%             defined by some base points
%% Input: 
%%   x -  value for which f should be evaluated
%%   BasePoints -  (N,2)-matrix of base points where N is the number
%%                 of base points. The first column contains the x-value
%%                 and the second column the y-value of the base points.
%%                 The base points must be sorted in ascending order of
%%                 their x-values.
%% Output: 
%%   y=f(x)


function y= LinIntpol( x, BasePoints )

[N, dummy]= size(BasePoints);

%x outside the base point interval
if x <= BasePoints(1,1) y= BasePoints(1,2); return; end;
if x >= BasePoints(N,1) y= BasePoints(N,2); return; end;

%find the appropriate interval
for i=1:N-1
   if BasePoints(i+1,1) > x break; end;
end;

%interpolation
if BasePoints(i+1,1)== BasePoints(i,1) y= BasePoints(i,2); return; end;
   
alpha= ( x-BasePoints(i,1) )/( BasePoints(i+1,1)-BasePoints(i,1) );
y= BasePoints(i,2)*(1.0-alpha) + BasePoints(i+1,2)*alpha;
