%% Description: Calculares the remaining stiffness Ktotal-Kspider.
%%              SeperateSuspension requires LinIntpol.m.
%%		
%% Input: 
%%   total  - base point matrix (see LinIntpol.m) for total stiffness 
%%   spider - base point matrix (see LinIntpol.m) for spider stiffness
%%   
%%   Please copy the files total.txt and spider.txt to Matlab\work before
%%   excecuting SeperateSuspension
%%
%% Output:
%%   remain - base point matrix of the remaining stiffness
%%
%%   The resulting matrix remain is also saved to Matlab\work\remain.txt

function remain= SeperateSuspension

load total.txt;
load spider.txt;

[Nt,dummy]= size(total);
[Ns,dummy]= size(spider);
Nr= Nt+Ns;

%sort base points matrices
[total(:,1), I]= sort(total(:,1));
total(:,2)= total(I,2);

[spider(:,1), I]= sort(spider(:,1));
spider(:,2)= spider(I,2);

remain= zeros(Nr,2);
remain(:,1)= sort([total(:,1); spider(:,1)]);

%correct spider offset
offset= 0; %insert your own spider offset here
for i=1:Ns, spider(i,1)= spider(i,1)-offset; end;

%remove base points that are
%outside the overlaping interval
MinX= max( total(1,1), spider(1,1) );
MaxX= min( total(Nt,1), spider(Ns,1) );
I=[];

for i=1:Nr
   if remain(i,1)>=MinX & remain(i,1)<=MaxX, I=[I;i]; end;
end;
remain= remain(I,:); [Nr dummy]= size(remain);

%calculate base point matrix for remain
for i=1:Nr
   x= remain(i,1);
	remain(i,2)= abs( LinIntpol(x,total)-LinIntpol(x,spider) );   
end;


plot( total(:,1),total(:,2), spider(:,1),spider(:,2), remain(:,1),remain(:,2) );
save remain.txt -ASCII;
remain