@echo off
REM    The batch file must be located in a top folder of the tests to be reported

REM Adapt the reportTemplate variable to integrate own templates
REM WARNING: Be careful with space characters
set reportTemplate="reportTemplates\SPL+IMP_Example_Template.htm" 

pushd "%~dp0"
echo %cd%
set batchpath=%cd%


REM correct version of cscript
if %PROCESSOR_ARCHITECTURE%==x86 (
  echo "32 bit architecture"
  set CSCRIPT=%windir%\System32\cscript.exe
)else (
  echo "64 bit architecture"
  set CSCRIPT=%windir%\SysWoW64\cscript.exe
)

IF @%1 == @ (goto L_USERINPUT) else (goto L_ONCALL)

:L_USERINPUT
echo PLEASE ENTER NAME OF QC-TEST FOLDER, FOLDER WITH DATABASES OR PATH TO DATABASE
echo a folderstructure is also valid (e.g.: CD50\woofer)
set /p name=
goto L_TESTINPUT

:L_USERINPUT2
echo PLEASE ENTER NAME OF QC-TEST FOLDER, FOLDER WITH DATABASES OR PATH TO DATABASE
echo if input remains not found script will abbort
set /p name=
IF EXIST "%name%" (goto L_TESTINPUT) ELSE goto L_SYNTAX

:L_ONCALL
set name="%~1"
goto L_TESTINPUT

:L_TESTINPUT
IF EXIST "%name%\*" (goto L_FOLDER) ELSE IF EXIST "%name%" (goto L_SINGLE) ELSE goto L_NOTFOUND

:L_FOLDER
pushd "%name%"
echo EXPORTING [%name%]...

REM CHECK IF QC-TEST FOLDER OR DATABASE FOLDER
IF EXIST "log" (pushd "log")
REM IF NOT EXIST "%name\log\*.log"  goto L_NOLOG

REM -- check, if at least one *.kdbx and one *.log exists
IF EXIST "*.kdbx" (goto L_KDBX) ELSE IF EXIST "*.kdb" (goto L_KDB) ELSE goto L_NODB

:L_KDBX
set database="*.kdbx"
goto L_PROCESS

:L_KDB
set database="*.kdb"
goto L_PROCESS

:L_PROCESS
set logPath=%cd%

REM -- reads all *.kdbx files from current folder, stop after first found (for limit export only one is required)

echo ...processing...

echo Source Path: "%batchpath%"
echo Target Path: "%logPath%\reports"

REM output source and target file
REM for /F "delims=" %%i in ('dir /b *.kdb') DO echo %%~fi  "->"  %batchPath%\%%~ni.html

if NOT EXIST reports mkdir reports

for /F "delims=" %%i in ('dir /b "%database%"') DO %CSCRIPT% //nologo "%batchpath%\create_Klippel_report.vbs" /np:\QC\QC /db:"%%~fi" /tf:"%reportTemplate%" /rf:"%logPath%\reports\%%~ni.html" /bp:"%batchPath%"
echo "%name%" done
goto L_End

:L_SINGLE
if NOT EXIST reports mkdir reports
%CSCRIPT%  //nologo "%batchpath%\create_Klippel_report.vbs" /np:\QC\QC /db:"%name%" /tf:"%reportTemplate%" /rf:"reports\%name%.htm" /bp:"%batchPath%"
goto :L_End


:L_NODB
echo NO DATA FOUND!
goto L_Syntax
 
:L_NOTESTFOLDER
echo FOLDER NOT FOUND. 
goto L_USERINPUT2

:L_SYNTAX
echo.
echo BATCH FILE MUST BE IN QC MASTER PATH OR INPUT PATH MUST LEAD FROM SCRIPT TO TEST FOLDER
echo.
pause
goto :L_End

:L_End
 
REM -- restore old working directory
popd
 
