Option explicit

' Declare constants
Const eDBFlagsNotDefined = 0
Const eDBLoad = 1
Const eDBStore = 2
Const eDBOverwriteFile = 8	'overwrite any existing file

Const eDBTemplatesKlippel = 1 'Klippel database templates
Const eDBTemplatesShared = 2 'User database templates
Const eDBTemplatesLocal	= 4 'Current database templates

' Declare the variables
Dim ar, msg, fso, path, nodepath, node, verbose, show
Dim db, modu, templateFile, reportFile
Dim argsNamed, shell, dbsrcpath, basepath

Sub ShowUsage()
		MsgBox "Usage:" + vbCrLf + "create_Klippel_report.vbs /np=\QC\QC /db=.\mydatabase.kdb(x) /tf=.\mytempl.htm /rf=\.\reportfile.htm [/bp:scriptpath] [/show] [/verbose:1]"  + vbCrLf + _
		+ vbCrLf + "db ... database file spec" + vbCrLf + _
		"/db:subdir\filename.kdb(x) ... requires /bp:basepathspec" + vbCrLf + _
		+ vbCrLf + "tf ... htm template file spec" + vbCrLf + _
		+ vbCrLf + "rf ... htm report file to be created" + vbCrLf + _
		+ vbCrLf + "bp ... base path spec to use relative file specs" + vbCrLf + _
		"/bp:scriptpath ... uses current script path as base path" + vbCrLf + _
		+ vbCrLf + "show ... open htm standard application (ie?)" + vbCrLf + _
		+ vbCrLf + "verbose:1 ... display messages" 
end Sub


Set argsNamed = WScript.Arguments.Named

if 4 > argsNamed.Count then
	ShowUsage
	WScript.Quit 1	
end if

'myScript.vbs /c:arg1 /d:arg2
if not argsNamed.Exists("np") Or not argsNamed.Exists("db") _
    Or not argsNamed.Exists("tf") Or not argsNamed.Exists("rf") then
	ShowUsage
	WScript.Quit 1
end if

' Get the file system object for file operations
Set fso = CreateObject("Scripting.FileSystemObject")

' figureout parent folder for files
if argsNamed.Exists("bp") then
	if "scriptpath" = argsNamed.Item("bp") then 
		basepath = fso.GetFile(WScript.ScriptFullName).ParentFolder
	else
		basepath = argsNamed.Item("bp")
	end if
end if

if not fso.FolderExists(basepath) then
	MsgBox "Cannot find base path=" + basepath
	WScript.Quit 1
end if

nodepath = argsNamed.Item("np")
dbsrcpath = argsNamed.Item("db")
templateFile = argsNamed.Item("tf")
reportFile = argsNamed.Item("rf")

if argsNamed.Exists("verbose") then	verbose = CInt(argsNamed.Item("verbose"))
if argsNamed.Exists("show") then show = 1

if "" = fso.GetDriveName(dbsrcpath) then dbsrcpath = basepath + "\" + dbsrcpath
if "" = fso.GetDriveName(templateFile) then templateFile = basepath + "\" + templateFile

' Figure out the current script path
if not fso.FileExists(dbsrcpath) then
	MsgBox "Cannot find database file=" + dbsrcpath
	WScript.Quit 1
end if

if not fso.FileExists(templateFile) then
	MsgBox "Cannot find htm template file=" + templateFile
	WScript.Quit 1
end if

if "" = fso.GetDriveName(reportFile) then reportFile = basepath + "\" + reportFile

Dim repParent
repParent = fso.GetParentFolderName(reportFile)
if not fso.FolderExists(repParent) then 
	MsgBox "Cannot find path to report file=" + repParent
	WScript.Quit 1
end if

' createReport requires full qualified absolute path names
dbsrcpath = fso.GetAbsolutePathName(dbsrcpath)
templateFile = fso.GetAbsolutePathName(templateFile)
reportFile = fso.GetAbsolutePathName(reportFile)

if 1 <= verbose then 
	MsgBox "Script: " + WScript.ScriptFullName + vbCrLf + _
		   "Database:" + vbTab + dbsrcpath + vbCrLf + _
		   "Template:" + vbTab + templateFile + vbCrLf + _
		   "Report:" + vbTab + vbTab + reportFile + vbCrLf + _
		   "Base path:" + vbTab + basepath
end if


' Create the automation registrar and instance checker
Set ar = CreateObject("KlAutomationRegistration.KlAutomationRegistrar.1")

' Request the dbLab version as minimum version
if not ar.ActivateInstallUI("202.0", 0, 0, msg) then
	MsgBox msg
	WScript.Quit 1
end if

' Provide some infos for the instance checker
ar.SetApplicationInfo WScript.ScriptFullName, 0, 0

' Create database instance
Set db = CreateObject("KlAutomation.KlDatabase")

' open database file
db.Open dbsrcpath, eDBFlagsNotDefined

' get access to operation node e.g. "\QC\QC"    
Set node = db.GetNode(nodepath)

' create a KlModule object from database node    
Set modu = node.LoadInstance

' create report from template
modu.Results.CreateReport templateFile, reportFile

' unlink database connection after loading data into the module
node.DiscardInstance

' unload database
db.Close

if not fso.FileExists(reportFile) then
	MsgBox "Cannot create report file=" + reportFile
	WScript.Quit 1	
end if

'if 1 <= verbose then MsgBox "Report file created in " + vbCrLf + reportFile

' ' show report file immediately
if 1=show then
	Set shell = CreateObject("WScript.Shell")
	shell.Run Chr(34) & reportFile & Chr(34), 1, false
end if



